using System;
using System.Windows.Forms;
using System.Collections;
using System.IO;
using System.Text;
using System.Xml;
using System.Reflection;
using System.Xml.Serialization;
using Borland.Studio.ToolsAPI;

namespace BeWise.SharpBuilderTools
{
	public class Main
	{
		/**************************************************************/
		/*                     Private
		/**************************************************************/
		private static Configuration fConfiguration;
		private static ArrayList fMenuNames = new ArrayList();
		private static ArrayList fMenuShortCuts = new ArrayList();
		private static Timer fTimer = new Timer();
		private static int fTimerRetry = 20;
		private static bool fShortcutEnabled = false; 
                                                                
		/**************************************************************/
		/*                     Protected
		/**************************************************************/

		protected static void CreateSharpToolMenu() {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));
			_MenuItem = _MenuService.AddMenuItem("ToolsMenu",
												 OTAMenuItemLocation.otamlBefore,
												 Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 "#Helpers");

			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												 "Edit");
			_MenuItem.Enabled = true;

			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_EDITOR_MENU_NAME,
												OTAMenuItemLocation.otamlAfter,
												Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												"View");
			_MenuItem.Enabled = true;
		}

		protected static void DoSetShortCut(object sender, EventArgs e){
			if (!fShortcutEnabled) {
				fShortcutEnabled = true;

				IOTAMainMenuService _MenuService = null;
				IOTAMenuItem _MenuItem = null;

				_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

				_MenuItem = _MenuService.GetMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME);
				_MenuItem.Enabled = true;

				for (int i = 0; i < fMenuNames.Count; i++) {
					_MenuItem = _MenuService.GetMenuItem((string) fMenuNames[i]);

					if ((_MenuItem != null) && ((int) fMenuShortCuts[i] != 0)) {
						_MenuItem.Shortcut = (int) fMenuShortCuts[i];
					}
				}
			}
		}

		protected static void RegisterMenus(string[] aMenuNames, int[] aMenuShortCuts) {
			for (int i = 0; i < aMenuNames.Length; i++){
				fMenuNames.Add(aMenuNames[i]);
				fMenuShortCuts.Add(aMenuShortCuts[i]);
			}
		}

		protected static void DoTimer(object sender, EventArgs e) {
			fTimerRetry--;

			// Stop the timer
			if (fTimerRetry <= 0) {
				fTimer.Enabled = false;
			}
			
			DoSetShortCut(null, null);
		}

		protected static void RegisterAboutBox() {
			IOTAAboutBoxService _AboutBoxService = (IOTAAboutBoxService) BorlandIDE.GetService(typeof(IOTAAboutBoxService));

			_AboutBoxService.AddProductInfo("Sharp Builder Tools", "", "Sharp Builder Tools 1.0", "", new IntPtr(0), new IntPtr(0), false, "", "");
		}

		/**************************************************************/
		/*                       Public
		/**************************************************************/

		public static void IDERegister()
		{
			try {
				LoadConfiguration();
				CreateSharpToolMenu();
				RegisterAboutBox();

				string[] _MenuNames;
				int[] _MenuShortCuts;

				new OTAMenuEnhancement().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAClipboard().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAAnt().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTACodeBeautifier().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAViewFiles().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAViewMethods().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAShell().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				new OTAOptions().IDERegister(out _MenuNames, out _MenuShortCuts);
				RegisterMenus(_MenuNames, _MenuShortCuts);

				fTimer.Interval = 1000;
				fTimer.Tick += new EventHandler(DoTimer);
				fTimer.Enabled = true;
			}
			catch (Exception e) {
				MessageBox.Show(e.Message + "--" + e.StackTrace);
			}
		}

		public static void LoadConfiguration() {
			fConfiguration = null;

			if (File.Exists(OptionFileName)) {
				XmlSerializer _Serializer = new XmlSerializer(typeof(Configuration));

				FileStream _FileStream = new FileStream(OptionFileName, FileMode.Open);
				XmlReader _Reader = new XmlTextReader(_FileStream);

				fConfiguration = (Configuration) _Serializer.Deserialize(_Reader);
			}
			else {
				fConfiguration = new Configuration();
			}

			SetDefaultConfiguration();
		}

		public static void SaveConfiguration() {
			SetDefaultConfiguration();

			XmlSerializer _Serializer = new XmlSerializer(typeof(Configuration));

			// Create an XmlSerializerNamespaces object.
			Stream _FileStream = new FileStream(OptionFileName, FileMode.Create);
			XmlWriter _Writer = new XmlTextWriter(_FileStream, new UTF8Encoding());

			// Serialize using the XmlTextWriter.
			_Serializer.Serialize(_Writer, fConfiguration);
			_Writer.Close();
		}

		public static void SetDefaultConfiguration(){
			if (fConfiguration.AStyleParams == "") {
				fConfiguration.AStyleParams = Consts.DEFAULT_ASTYLE_PARAMS;
			}
		}
		
		/**************************************************************/
		/*                     Properties
		/**************************************************************/

		public static Configuration Configuration {
			get {
				return fConfiguration;
			}
		}

		public static string OptionFileName {
			get {
				string _Path  = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\";

				return _Path + "SharpBuilderTools.xml";
			}
		}

	}
}
